//
//  Text.m
//  POSSDKDebug
//
//  Created by liangchenying on 12-3-31.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "Text.h"
#import "ButtonPullDownPrepare.h"
#import "ButtonPullDownRealize.h"

@interface Text()

@property (nonatomic, retain) POSSDK        *pos_sdk;
@end

@implementation Text

@synthesize ReverseAble;
@synthesize BoldAble;

@synthesize Back;
@synthesize TextPrint;
@synthesize HorizontalTimesButton;
@synthesize VerticalTimesButton;
@synthesize AlignmentButton;
@synthesize textContent;
@synthesize Cut;
@synthesize RotateButton;
@synthesize UnderlineButton;
@synthesize CharacterSpace;
@synthesize LineHeight;
@synthesize TextColorPrint;
@synthesize FontTypeButton;

@synthesize pos_sdk		            = _pos_sdk;

@synthesize array_HorizontalTimes   = _array_HorizontalTimes;
@synthesize array_VerticalTimes	    = _array_VerticalTimes;
@synthesize array_Alignment		    = _array_Alignment;
@synthesize array_Rotate		    = _array_Rotate;
@synthesize array_Underline		    = _array_Underline;
@synthesize array_FontType		    = _array_FontType;

@synthesize selectedHorizontalTimes = _selectedHorizontalTimes;
@synthesize selectedVerticalTimes	= _selectedVerticalTimes;
@synthesize selectedAlignment		= _selectedAlignment;
@synthesize selectedRotate		    = _selectedRotate;
@synthesize selectedUnderline		= _selectedUnderline;
@synthesize selectedFontType		= _selectedFontType;

- (NSMutableArray*)array_HorizontalTimes
{
    if(_array_HorizontalTimes  == nil)
    {
        _array_HorizontalTimes = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_HorizontalTimes;
}

- (NSMutableArray*)array_VerticalTimes
{
    if(_array_VerticalTimes  == nil)
    {
        _array_VerticalTimes = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_VerticalTimes;
}

- (NSMutableArray*)array_Alignment
{
    if(_array_Alignment  == nil)
    {
        _array_Alignment = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_Alignment;
}

- (NSMutableArray*)array_Rotate
{
    if(_array_Rotate  == nil)
    {
        _array_Rotate = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_Rotate;
}

- (NSMutableArray*)array_Underline
{
    if(_array_Underline  == nil)
    {
        _array_Underline = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_Underline;
}

- (NSMutableArray*)array_FontType
{
    if(_array_FontType  == nil)
    {
        _array_FontType = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_FontType;
}



- (id)initWithNibNamePOSSDK:(NSString *)nibNameOrNil pos_sdk:(POSSDK*)pos_sdk bundle:(NSBundle *)nibBundleOrNil
{
    self.pos_sdk = pos_sdk;
    return [self initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
}
- (NSInteger)NSArrayToInt:(NSMutableArray *)Array  Index:(NSInteger)Index
{
    NSInteger INT; 
    NSString *String = nil;
    String = [Array objectAtIndex:Index];
    INT = [String intValue];
 
    return INT;
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) 
    {
        //**************************************************************************************************
        //Add object for array_HorizontalTimes
        [self.array_HorizontalTimes addObject:@"1"];
        [self.array_HorizontalTimes addObject:@"2"];
        [self.array_HorizontalTimes addObject:@"3"];
        [self.array_HorizontalTimes addObject:@"4"];
        [self.array_HorizontalTimes addObject:@"5"];
        [self.array_HorizontalTimes addObject:@"6"];
   
        //**************************************************************************************************
        //Add object for array_VerticalTimes
        [self.array_VerticalTimes addObject:@"1"];
        [self.array_VerticalTimes addObject:@"2"];
        [self.array_VerticalTimes addObject:@"3"];
        [self.array_VerticalTimes addObject:@"4"];
        [self.array_VerticalTimes addObject:@"5"];
        [self.array_VerticalTimes addObject:@"6"];
 
        //**************************************************************************************************
        //Add object for array_Alignment
        [self.array_Alignment addObject:@"Left Justification"];
        [self.array_Alignment addObject:@"Centering"];
        [self.array_Alignment addObject:@"Right Justification"];
	
        //**************************************************************************************************
        //Add object for array_Rotate
		[self.array_Rotate addObject:@"Normal"];
        [self.array_Rotate addObject:@"Clockwise 90 Degree"];
        [self.array_Rotate addObject:@"Clockwise 180 Degree"];
        [self.array_Rotate addObject:@"Clockwise 270 Degree"];
    
        //**************************************************************************************************
        //Add object for array_Underline
        [self.array_Underline addObject:@"None"];
        [self.array_Underline addObject:@"1 Dot Thick"];
        [self.array_Underline addObject:@"2 Dot Thick"];
      
        //**************************************************************************************************
        //Add object for array_FontType
		[self.array_FontType addObject:@"Standard ASCII"];
        [self.array_FontType addObject:@"Compressed ASCII"];
        [self.array_FontType addObject:@"User Defined"];
        [self.array_FontType addObject:@"Chinese"];
        
    }
    return self;
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];

    self.selectedHorizontalTimes = 0;
    self.selectedVerticalTimes   = 0;
    self.selectedAlignment       = 0;
    self.selectedRotate          = 0;
    self.selectedUnderline       = 0;
    self.selectedFontType        = 0;

    
    [self.textContent    setDelegate:self];
    [self.CharacterSpace setDelegate:self];
    [self.LineHeight     setDelegate:self];

    [self.HorizontalTimesButton setTitle:@"1" forState:UIControlStateNormal];
    [self.VerticalTimesButton   setTitle:@"1" forState:UIControlStateNormal]; 
    [self.AlignmentButton       setTitle:@"Left Justification" forState:UIControlStateNormal];
    [self.RotateButton          setTitle:@"Normal" forState:UIControlStateNormal];
    [self.UnderlineButton       setTitle:@"None" forState:UIControlStateNormal];
    [self.FontTypeButton        setTitle:@"Standard ASCII" forState:UIControlStateNormal];
    
    [self.textContent     setText:@"We strive to be the expert supplier of printers.Our POS series printers can print text,image and barcode.It's a wise choice for you to choose our printers."];
	
	[self.CharacterSpace setText:@"0"];
    [self.LineHeight     setText:@"34"];
}

- (void)viewDidUnload
{
    [self setReverseAble:nil];
    [self setBoldAble:nil];  
    [self setBack:nil];
    [self setTextPrint:nil];
    [self setHorizontalTimesButton:nil];
    [self setVerticalTimesButton:nil];
    [self setAlignmentButton:nil];
    [self setTextContent:nil];
    [self setCut:nil];
    [self setUnderlineButton:nil];
    [self setCharacterSpace:nil];
    [self setLineHeight:nil];
    [self setTextColorPrint:nil];
    [self setFontTypeButton:nil];
    
	[self setRotateButton:nil];
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

//**************************************************************************************************
//Exit the keyboard by clicking "return" for UITextView
- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text
{
    if ([text isEqualToString:@"\n"])
    {
        [self.textContent resignFirstResponder];
        return NO;
    }
    return YES;
}

//**************************************************************************************************
//Exit the keyboard by clicking "return" for UITextField
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    if ([string isEqualToString:@"\n"])
    {
        [self.CharacterSpace resignFirstResponder];
        [self.LineHeight     resignFirstResponder];
        return NO;
    } 
return YES;
}

//**************************************************************************************************
//Return to the main View by press the button "Back"
- (IBAction)Back:(id)sender 
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

//**************************************************************************************************
//select Horizontal Times Index
- (IBAction)selectHorizontalTimes:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedHorizontalTimes = selectedIndex;
        
        [self.HorizontalTimesButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Horizontal Times" Sheet:self.array_HorizontalTimes Selected:self.selectedHorizontalTimes DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//select vertical Times Index
- (IBAction)selectverticalTimes:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedVerticalTimes = selectedIndex;
        
        [self.VerticalTimesButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Vertical Times" Sheet:self.array_VerticalTimes Selected:self.selectedVerticalTimes DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//select Alignment Index
- (IBAction)selectAlignment:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedAlignment = selectedIndex;
        
        [self.AlignmentButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Alignment" Sheet:self.array_Alignment Selected:self.selectedAlignment DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//select Rotate Index
- (IBAction)selectRotate:(id)sender 
{
	PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedRotate = selectedIndex;
        
        [self.RotateButton setTitle:selectedValue forState:UIControlStateNormal];
    };
	
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
	
    [ButtonPullDownRealize sheetPickerTitle:@"Rotate" Sheet:self.array_Rotate Selected:self.selectedRotate DoneButton:done CancelButton:cancel Action:sender]; 
	
}

//**************************************************************************************************
//select Underline Mode Index
- (IBAction)selectUnderline:(id)sender
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedUnderline = selectedIndex;
        
        [self.UnderlineButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Underline" Sheet:self.array_Underline Selected:self.selectedUnderline DoneButton:done CancelButton:cancel Action:sender];    
}

//**************************************************************************************************
//select Font Type Index
- (IBAction)selectFontType:(id)sender
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedFontType = selectedIndex;
        
        [self.FontTypeButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Underline" Sheet:self.array_FontType Selected:self.selectedFontType DoneButton:done CancelButton:cancel Action:sender];    
}

//**************************************************************************************************
//Print text
- (IBAction)textPrint:(id)sender 
{
    SInt32   error_code       = SUCCESS;
    SInt32   horizontal_times = 0;
    SInt32   vertical_time    = 0;
    SInt32   rotate           = 0;
    SInt32   character_space  = 0;
	SInt32   line_Height      = 0;
    SInt32   underline        = 0;
    SInt32   i                = 0;
	SInt32   Reverse          = 0;
	SInt32   Bold             = 0;
    SInt32   font_type        = 0;
	SInt32   font_style       = 0;
    
    //**************************************************************************************************
    //If Text Conent == nil ,text cannot be printed.
    JudgeParamNil(textContent, @"Text == nil,Please input text content");
	
    //**************************************************************************************************
    //If CharacterSpace == nil ,Set CharacterSpace = 0.
    if ([self.CharacterSpace.text isEqualToString:@""]) 
    {
        self.CharacterSpace.text = @"0";        
    }
    
    //**********************************************************************************************
	//Judge Character Space must be digits
    JudgeParamDigitOrNot(CharacterSpace, @"ERROR Character Space! It must be  0-255.");
    
    character_space = [self.CharacterSpace.text intValue];//Character Space Value
    
    //**********************************************************************************************
	//Judge Character Space must 0-255
    JudgeParamRange(character_space, 0, 255, @"ERROR Character Spaceh! It must be  0-255.");
    
    //**************************************************************************************************
    //If LineHeight == nil ,Set LineHeight = 34.
    if ([self.LineHeight.text isEqualToString:@""]) 
    {
        self.LineHeight.text = @"34";        
    }

    //**********************************************************************************************
	//Judge Line Height must be digits
    JudgeParamDigitOrNot(LineHeight, @"ERROR Line Height! It must be  0-255.");
    
    line_Height = [self.LineHeight.text intValue];    //Line Height Value
    
    //**********************************************************************************************
	//Judge Line Height must 0-255
    JudgeParamRange(line_Height, 0, 255, @"ERROR Line Height! It must be  0-255.");
    
    //**************************************************************************************************
    //Set Motion Unit
    error_code = [self.pos_sdk systemSetMotionUnit:203 VerticalUnit:203];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
        goto ExitLine;
    }

    //**************************************************************************************************
    //Set Character space
    error_code = [self.pos_sdk textSetCharacterSpace:10 RightSpace:character_space Mode:EnglishCharacterMode];//Realize seting character space
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }

    //**************************************************************************************************
    //Set line Height
    error_code = [self.pos_sdk textSetLineHeight:line_Height];       //Realize seting Line space
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }
    
    //**************************************************************************************************
    //Get the Status of Switch
    Reverse = (ReverseAble.on == 0 ? 0 : FontStyleReverse);
    Bold    = (BoldAble.on == 0 ? 0 : FontStyleBold);

	if(self.selectedUnderline == 0)	        underline = 0;
	else if(self.selectedUnderline == 1)	underline = FontStyleUnderlineOneDotThick;
	else if(self.selectedUnderline == 2)	underline = FontStyleUnderlineTwoDotThick;

    //**************************************************************************************************
    //Set font and Font style
    if(self.selectedFontType == 0)          font_type = FontTypeStandardASCII;
    else if(self.selectedFontType == 1)     font_type = FontTypeCompressedASCII;
    else if(self.selectedFontType == 2)     font_type = FontTypeUserDefined;
    else if(self.selectedFontType == 3)     font_type = FontTypeChinese;
    
    font_style = Reverse | Bold | underline;
	error_code = [self.pos_sdk textSelectFont:font_type FontStyle:font_style];
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }
	
    //**************************************************************************************************
    //Set Alignment mode in standard mode 
    error_code = [self.pos_sdk textStandardModeAlignment:self.selectedAlignment];//Select Alignment
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }
    
    //**************************************************************************************************
    //Get the selected HorizontalTimes and VerticalTimes
    horizontal_times = [self NSArrayToInt:self.array_HorizontalTimes Index:self.selectedHorizontalTimes]; 
    vertical_time    = [self NSArrayToInt:self.array_VerticalTimes Index:self.selectedVerticalTimes]; 
    
    //**************************************************************************************************
    //Realize text font magnify
    error_code = [self.pos_sdk textSelectFontMagnifyTimes:horizontal_times VerticalTimes:vertical_time];
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
	}

   
    //**************************************************************************************************
    //Get rotation degree
    if(self.selectedRotate == 0)          rotate = RotatePrintNormal;
    else if(self.selectedRotate == 1)     rotate = RotatePrintR90;
    else if(self.selectedRotate == 2)     rotate = RotatePrint180;
    else if(self.selectedRotate == 3)     rotate = RotatePrintL90;

	//**************************************************************************************************
    //Realize text rotate(Integer times 90 degree)
    error_code = [self.pos_sdk textStandardModeRotate:rotate];
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }
   
    //**************************************************************************************************
    //Print string
    error_code = [self.pos_sdk textPrint:self.textContent.text];
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }
    //**************************************************************************************************
    //Feed Line
    error_code = [self.pos_sdk systemFeedLine:1];
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }

ExitLine:
    return;
}

//**************************************************************************************************
//Print color text
- (IBAction)textColorPrint:(id)sender 
{
    SInt32   error_code       = SUCCESS;
    SInt32   horizontal_times = 0;
    SInt32   vertical_time    = 0;
    SInt32   rotate           = 0;
    SInt32   character_space  = 0;
	SInt32   line_Height      = 0;
    SInt32   i                = 0;
	SInt32   Reverse          = 0;
	SInt32   Bold             = 0;
    SInt32   font_type        = 0;
	SInt32   font_style       = 0;
	SInt32   underline        = 0;
 
    //**************************************************************************************************
    //If Text Conent == nil ,text cannot be printed.
    JudgeParamNil(textContent, @"Text == nil,Please input text content");
    
    //**************************************************************************************************
    //If CharacterSpace == nil ,Set CharacterSpace = 0.
    if ([self.CharacterSpace.text isEqualToString:@""]) 
    {
        self.CharacterSpace.text = @"0";        
    }
    //**********************************************************************************************
	//Judge Character Space must be digits
    JudgeParamDigitOrNot(CharacterSpace, @"ERROR Character Space! It must be  0-255.");
    
    character_space = [self.CharacterSpace.text intValue];//Character Space Value
    
    //**********************************************************************************************
	//Judge Character Space must 0-255
    JudgeParamRange(character_space, 0, 255, @"ERROR Character Spaceh! It must be  0-255.");
    
    //**************************************************************************************************
    //If LineHeight == nil ,Set LineHeight = 34.
    if ([self.LineHeight.text isEqualToString:@""]) 
    {
        self.LineHeight.text = @"34";        
    }

    //**********************************************************************************************
	//Judge Line Height must be digits
    JudgeParamDigitOrNot(LineHeight, @"ERROR Line Height! It must be  0-255.");
    
    line_Height     = [self.LineHeight.text intValue];    //Line Height Value
    
    //**********************************************************************************************
	//Judge Line Height must 0-255
    JudgeParamRange(line_Height, 0, 255, @"ERROR Line Height! It must be  0-255.");
    
    //**************************************************************************************************
    //Set Motion Unit
    error_code = [self.pos_sdk systemSetMotionUnit:203 VerticalUnit:203];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }
    
    //**************************************************************************************************
    //Set Character space
    error_code = [self.pos_sdk textSetCharacterSpace:10 RightSpace:character_space Mode:EnglishCharacterMode];
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }
 
    //**************************************************************************************************
    //Set line Height
    error_code = [self.pos_sdk textSetLineHeight:line_Height]; 
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }
    
    //**************************************************************************************************
    //Get the Status of Switch
    Reverse    = (ReverseAble.on == 0 ? 0 : FontStyleReverse);
    Bold       = (BoldAble.on == 0 ? 0 : FontStyleBold);
	
	if(self.selectedUnderline == 0)	        underline = 0;
	else if(self.selectedUnderline == 1)	underline = FontStyleUnderlineOneDotThick;
	else if(self.selectedUnderline == 2)	underline = FontStyleUnderlineTwoDotThick;
    
    //**************************************************************************************************
    //Set font and Font style    
    if(self.selectedFontType == 0)          font_type = FontTypeStandardASCII;
    else if(self.selectedFontType == 1)     font_type = FontTypeCompressedASCII;
    else if(self.selectedFontType == 2)     font_type = FontTypeUserDefined;
    else if(self.selectedFontType == 3)     font_type = FontTypeChinese;
    
    font_style = Reverse | Bold | underline;
	error_code = [self.pos_sdk textSelectFont:font_type FontStyle:font_style];
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }
    
    //**************************************************************************************************
    //Set Alignment mode in standard mode 
    error_code = [self.pos_sdk textStandardModeAlignment:self.selectedAlignment];//Select Alignment
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }
    
     //**************************************************************************************************
    //Get the selected HorizontalTimes and VerticalTimes
    horizontal_times = [self NSArrayToInt:self.array_HorizontalTimes Index:self.selectedHorizontalTimes]; 
    vertical_time    = [self NSArrayToInt:self.array_VerticalTimes Index:self.selectedVerticalTimes]; 
    
     //**************************************************************************************************
    //Realize text font magnify
    error_code = [self.pos_sdk textSelectFontMagnifyTimes:horizontal_times VerticalTimes:vertical_time];
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }
    
     //**************************************************************************************************
    //Get rotation degree
    if(self.selectedRotate == 0)          rotate = RotatePrintNormal;
    else if(self.selectedRotate == 1)     rotate = RotatePrintR90;
    else if(self.selectedRotate == 2)     rotate = RotatePrint180;
    else if(self.selectedRotate == 3)     rotate = RotatePrintL90;

    //**************************************************************************************************
    //Realize text rotate(Integer times 90 degree)
    error_code = [self.pos_sdk textStandardModeRotate:rotate];
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }
    
    //**************************************************************************************************
    //Enter color print and select the color  
    error_code = [self.pos_sdk textSetColorPrint];
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }

     //**************************************************************************************************
    //Print text
    error_code = [self.pos_sdk textPrint:self.textContent.text];
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }
    
    //**************************************************************************************************
    //Feed Line
    error_code = [self.pos_sdk systemFeedLine:1]; 
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }

    //**************************************************************************************************
    //Quit Color print
    error_code = [self.pos_sdk textQuitColorPrint];
    if (error_code != SUCCESS) 
    {
        goto ExitLine;
    }
        
ExitLine:
    return;
}

- (IBAction)Cut:(id)sender
{
   SInt32 error_code = SUCCESS;
    
    error_code = [self.pos_sdk systemCutPaper:CutPartAfterFeed FeedDistance:50];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }  
    
ExitLine:
    return;
}

- (void)dealloc
{
  
    [self.ReverseAble release];
    [self.BoldAble release];
    [self.Back release];
    [self.TextPrint release];
    [self.HorizontalTimesButton release];
    [self.VerticalTimesButton release];   
    [self.AlignmentButton release];
    [self.textContent release];
    [self.Cut release];
    [self.UnderlineButton release];  
    [self.CharacterSpace release];
    [self.LineHeight release];
    [self.TextColorPrint release];
    [self.FontTypeButton release];
	[self.RotateButton release];
    
    [self.array_Underline release];
    [self.array_HorizontalTimes release];
    [self.array_VerticalTimes release];
    [self.array_Alignment release];
    [self.array_Rotate release];
    [self.array_FontType release];
	
    [super dealloc];
}
@end
